<?php
/*
Plugin Name: ICOMST Certificate Generator
Description: Generates PDF certificates based on the email link.
Version: 1.0
Author: Your Name
*/

require_once 'fpdf.php';

function icomst_generate_certificate() {
    global $wpdb;
    
    $request_uri = $_SERVER['REQUEST_URI'];
    if (strpos($request_uri, '/certificate/') !== false) {
        $email = explode('/', $request_uri);
        $email = end($email);
        
        // Fetch certificate details from the database
        $table_name = $wpdb->prefix . 'icomst_certificado';
        $certificate = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE email = %s", $email));
        
        if ($certificate) {
            
            // Generate PDF
            $pdf = new FPDF('L', 'mm', 'A4');
            $pdf->AddPage();
            
            // Set background image
            $background = plugin_dir_path(__FILE__) . 'fundo.jpg';
            $pdf->Image($background, 0, 0, 297, 210); // A4 size (210x297 mm)
            
            // Set font
            $pdf->SetFont('Arial', 'B', 28);
            $pdf->SetTextColor(0, 0, 0);
            
            // Add the name in the center
            $pdf->SetXY(0, 102);
            $pdf->Cell(297, 10, $certificate->nome, 0, 0, 'C');
            
            // Output the PDF
            $pdf->Output('D', date('his').'ICoMST2024_certificate.pdf'); // Force download
            exit;
        } else {
            wp_die('No certificate found for this email.'.$email);
        }
    }
}

add_action('init', 'icomst_generate_certificate');
